# coding: utf-8

from django.db import models
from gm_types.gaia import SERVICE_ADVERTISE_TYPE
from gm_upload import ImgUrlField, IMG_TYPE
from api.models import Doctor
from api.models import Hospital
from api.models import Service
from api.models import Tag
from api.models import ItemWiki
from gm_upload import IMG_TYPE, ImgUrlField


class AdvertiseDoctor(models.Model):
    class Meta:
        verbose_name = u'医生广告位'
        db_table = 'api_advertisedoctor'
        app_label = 'api'

    doctor = models.ForeignKey(Doctor)  # unique
    rank = models.IntegerField(verbose_name=u'排序')  # unique


class AdvertiseHospital(models.Model):
    class Meta:
        verbose_name = u'机构广告位'
        db_table = 'api_advertisehospital'
        app_label = 'api'

    hospital = models.ForeignKey(Hospital)
    rank = models.IntegerField(verbose_name=u'排序')
    portrait = ImgUrlField(img_type=IMG_TYPE.ADVERTISE, max_length=120, verbose_name=u'头像')


class AdvertiseService(models.Model):
    class Meta:
        verbose_name = u'美购广告位'
        db_table = 'api_advertiseservice'
        app_label = 'api'

    service = models.ForeignKey(Service)
    rank = models.IntegerField(verbose_name=u'排序', default=0)
    advertise_type = models.IntegerField(verbose_name=u'广告类型', choices=SERVICE_ADVERTISE_TYPE)


class WikiAdver(models.Model):
    class Meta:
        verbose_name = u'wiki广告位'
        db_table = u'api_wikiadver'
        app_label = u'api'

    image_header = ImgUrlField(img_type=IMG_TYPE.ADVERTISE, max_length=300, verbose_name=u'wiki广告为地址', default=u'')
    download_link = models.CharField(max_length=300, verbose_name=u'跳转到')
    url_type = models.CharField(max_length=300, verbose_name=u'跳转ID/URL/TYPE')
    itemwiki = models.ForeignKey(ItemWiki)
    is_online = models.BooleanField(verbose_name=u'是否上线', default=False)
    # TODO: tag外键删掉后 下个迭代将数据库中的字段删掉

    def data(self):
        return {
            'url': self.download_link,
            'url_type': self.url_type,
            'image': self.image_header,
            'tag_id': self.tag.id
        }
