# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from api.models.service import Service
from django.db import models


class DoctorBigSaleShow(models.Model):
    class Meta:
        verbose_name = u'大促名医临时展示'
        app_label = 'api'

    doctor_name = models.CharField(max_length=100, verbose_name='医生姓名')
    hospital_name = models.CharField(max_length=200, verbose_name='医院名字')
    position = models.IntegerField(verbose_name='医生显示顺序', default=0)
    image = models.CharField(max_length=128, verbose_name='图片')
    service = models.ForeignKey(Service, verbose_name='关联的福利', related_name='doctor_bigsale_show')
    description = models.CharField(max_length=50, verbose_name='描述')

    @property
    def data(self):
        return {
            'doctor_name': self.doctor_name,
            'hospital_name': self.hospital_name,
            'image': self.image,
            'service_id': self.service_id,
            'description': self.description,
        }
