# -*- coding: utf-8 -*-
from django.db import models
from gm_types.gaia import ROLE_TYPE

from api.models.base_model import BaseModel


class BusinessCityRelation(BaseModel):
    """
    商务城市关系
    """
    class Meta:
        verbose_name = '商务城市关系'
        verbose_name_plural = '商务城市关系'
        db_table = 'api_business_city_relation'
        app_label = 'api'

    advertisement_name = models.CharField(verbose_name=u'姓名', max_length=100)
    username = models.CharField(verbose_name=u'用户名', max_length=100)
    role_type = models.CharField(verbose_name=u'角色类型', max_length=8, choices=ROLE_TYPE, default=ROLE_TYPE.BDM)
    group = models.CharField(verbose_name=u'商务组', max_length=100)
    city_ids = models.TextField(verbose_name=u'城市列表')
    operator = models.IntegerField(verbose_name=u'操作人ID')
