#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/03/14 19:55:07
#   Desc    :   礼包渠道
#

from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE


class BusinessChannel(models.Model):

    class Meta:
        db_table = 'api_business_channel'
        verbose_name = u'美券大礼包渠道'
        app_label = 'api'

    id = models.IntegerField(primary_key=True)
    desc = models.CharField(u'渠道名称', unique=True, max_length=50)
    memo = models.TextField(verbose_name='备注', default='')
    activated_time = models.DateTimeField(verbose_name='生效时间', null=True)
    created_time = models.DateTimeField(verbose_name='创建时间', auto_now_add=True)

    @classmethod
    def channel_list(cls):
        return [(x.id, x.desc) for x in cls.objects.all()]

    @classmethod
    def getDesc(cls, index):
        return cls.objects.get(id=index).desc

    @classmethod
    def append(cls, channel, memo=""):
        max_id = cls.objects.all().aggregate(models.Max('id'))['id__max']
        return cls.objects.create(id=max_id+1, desc=channel, memo=memo)


class CouponChannel(models.Model):

    class Meta:
        verbose_name = u'领券渠道'
        db_table = 'api_couponchannel'
        app_label = 'api'

    name = models.CharField(verbose_name=u'渠道名', max_length=100)
    number = models.IntegerField(verbose_name=u'渠道号')
    phone_image = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=255, verbose_name=u'手机号背景图')
    coupon_image = ImgUrlField(img_type=IMG_TYPE.NOWATERMARK, max_length=255, verbose_name=u'领券背景图')
    package_id = models.IntegerField(verbose_name=u'礼包ID')
    download = models.CharField(verbose_name=u'下载地址', max_length=255)
