# coding=utf8

from django.db.models import Model
from django.db.models import ForeignKey, DateTimeField, CharField

from gm_upload import IMG_TYPE, ImgUrlField

from api.models import Service, User
from hippo.models import Doctor, Hospital


class ReportDoctor(Model):
    class Meta:
        verbose_name = u'用户举报医生'

    user = ForeignKey(User)
    service = ForeignKey(Service, null=True)
    doctor = ForeignKey(Doctor, null=True)
    hospital = ForeignKey(Hospital, null=True)
    comment = CharField(max_length=300)
    create_time = DateTimeField(auto_now_add=True)


class ReportImages(Model):
    class Meta:
        verbose_name = u'用户举报关联图'

    report = ForeignKey(ReportDoctor, related_name='images')
    image = ImgUrlField(img_type=IMG_TYPE.WATERMARK, max_length=100)