from api.models.icon import Icon
from rpc.tool.dict_mixin import to_dict


class IconService(object):
    @classmethod
    def get_icon_list(cls):
        data = []
        icons = Icon.objects.filter(is_online=True).order_by('order')
        id_title_map = {}
        for icon in icons:
            data.append(to_dict(icon))
            id_title_map.update({str(icon.id): icon.title})

        return {
            'total': len(data),
            'id_title_map': id_title_map,
            'data': data
        }
