# coding=utf-8
# create by esse at 2018/4/18

from injection.utils.table_scan import TableSlicer
from trans2es.type_info import TypeInfo
import logging
from celery import shared_task
from trans2es.type_info import get_type_info_map
from trans2es.management.commands.trans2es_data2es_parallel import Job
from django.conf import settings


@shared_task
def get_keyword():

    def iter_jobs():

        type_info = get_type_info_map()["wiki_keyword"]
        assert isinstance(type_info, TypeInfo)

        queryset = type_info.queryset

        slicer = TableSlicer(
            queryset=queryset,
            chunk_size=type_info.bulk_insert_chunk_size,
        )
        index_prefix = settings.ES_INDEX_PREFIX

        for chunk in slicer.chunks():
            job = Job(
                index_prefix=index_prefix,
                type_name="wiki_keyword",
                chunk=chunk,
            )

            yield job

    print('* PARALLEL DISABLED')

    for job in iter_jobs():
        job()
