#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/09/21 14:57:16
#   Desc    :   
#

from django.conf import settings

from gm_dbmw_api.descriptor.connection import Connection, _TaskGroupCategory
from gm_dbmw_api.descriptor.source import GroupedSource, MySQLTableScanSource
from gm_dbmw_api.descriptor.sink import CeleryV1Sink
from gm_dbmw_api.descriptor.source import MySQLTableSource


DB = settings.DATABASES['default']['NAME']


sink_update_with_tag = CeleryV1Sink(
    task='api.tasks.special_service_dbmw.update_with_tag',
    key_list_param_name='ids',
    static_params_json='{}',
    broker_url=settings.BROKER_URL,
    queue='',
    unpack_input_tuple=True,
    batch_size_limit=20,
    flow_rate_limit=20.0,
    push_rate_limit=3.0,
    preferred_batch_size=20,
    linger_seconds=3.0,
)

connection_update_with_tag = Connection(
    name='special_service_dbmw',
    sink=sink_update_with_tag,
    task_group_category=_TaskGroupCategory.ONLINE,
    source=GroupedSource.of(
        MySQLTableSource(
            logical_database_id=DB,
            table_name='api_tag',
            key_columns=['id'],
            value_columns=['is_online', 'tag_type', 'name']
        ),
        MySQLTableSource(
            logical_database_id=DB,
            table_name='api_servicetag',
            key_columns=['tag_id'],
            value_columns=['service_id', 'tag_id']
        ),
        MySQLTableSource(
            logical_database_id=DB,
            key_columns=['tag_id'],
            value_columns=['special_id', 'tag_id'],
            table_name='api_special_rule'
        )
    )
)

sink_update_with_special = CeleryV1Sink(
    task='api.tasks.special_service_dbmw.update_with_special',
    key_list_param_name='ids',
    static_params_json='{}',
    broker_url=settings.BROKER_URL,
    queue='gaia-dbmw',
    unpack_input_tuple=True,
    batch_size_limit=20,
    flow_rate_limit=20.0,
    push_rate_limit=3.0,
    preferred_batch_size=20,
    linger_seconds=3.0,
)

connection_update_with_special = Connection(
    name='special_service_dbmw_with_special',
    sink=sink_update_with_special,
    task_group_category=_TaskGroupCategory.ONLINE,
    source=GroupedSource.of(
        MySQLTableSource(
            logical_database_id=DB,
            key_columns=['special_id'],
            value_columns=['special_id', 'tag_id'],
            table_name='api_special_rule'
        )
    )
)

round_connection_update_with_special = Connection(
    name='round_special_service_dbmw_with_special',
    sink=sink_update_with_special,
    task_group_category=_TaskGroupCategory.ROUND_SCANNING,
    source=MySQLTableScanSource(
        logical_database_id=DB,
        key_columns=['id'],
        table_name='api_special',
        reversed_scanning=True,  # 倒序扫描
        cyclic=True,  # 循环scan
        scan_rate=8,  # 每秒处理个数？
    )
)
