# coding=utf-8
import datetime
import time
import pytz
from django.conf import settings
from api.tasks.push_task import allocate_push_task_one
from api.models import PLATFORM_CHOICES
from api.tool import sms_tool


def _filter_valid_phone(phone):
    # valid_phone_list = []
    #
    # if not phone:
    #     return valid_phone_list
    #
    # if not isinstance(phone, list):
    #     phone_list = [phone]
    # else:
    #     phone_list = phone
    #
    # for one_phone in phone_list:
    #
    # return valid_phone_list
    if phone and phone.isdigit() and len(phone) == 11 and phone != '18618133328':
        return phone
    else:
        return None


def send_sms(phone, msg):
    """
    已废弃
    """
    # 相比sms_tool 多了一层
    # 多了一层手机号合法性校验
    phone = _filter_valid_phone(phone)
    if phone:
        sms_tool.send_sms(phone=phone, msg=msg, temp_id=None, params='', channel='md')


def can_send_remind(current_datetime):
    # 当前时间是否可以给用户发短信推送
    if current_datetime.hour >= settings.NOTIFICATION_START_HOUR and current_datetime.hour < settings.NOTIFICATION_STOP_HOUR:
        return True
    else:
        return False