# -*- coding:utf-8 -*-
'''
    用户动作触发器
'''

from gm_types.gaia import USER_CHANGE_LOG_TYPE, USER_CHANGE_LOG_OPERATE_TYPE
from api.tasks.user_related_tasks import record_device_info, update_device_pushinfo, follow_suozhang, set_city_by_lat_lng_or_cityname, record_user_change_log
from api.util.message_util import _send_welcome_notification
from rpc.tool.log_tool import user_logger, logging_exception
from mimas.event_manager import EventDispatcher


def login_trigger(_user_id, extra_info=None):
    """
        用户登录时触发
    """
    if _user_id:
        user_logger.info('[TRIG] user(%s) trigger login_trigger' % (_user_id))
        extra_info = extra_info or {}
        if extra_info:
            record_device_info.delay(_user_id, **extra_info)
            update_device_pushinfo.delay(user_id=_user_id, **extra_info)


def reg_trigger(_user_id, extra_info=None):
    """
    用户注册时触发
    """
    if _user_id:
        user_logger.info('[TRIG] user(%s) trigger the reg_trigger' % (_user_id))
        extra_info = extra_info or {}
        follow_suozhang.delay(_user_id)
        set_city_by_lat_lng_or_cityname.delay(_user_id, extra_info.get('lat'), extra_info.get('lng'))
        _send_welcome_notification(_user_id)
        EventDispatcher.sent_bind_phone_signal(_user_id)


def user_change_trigger(user_id,
                        change_type=USER_CHANGE_LOG_TYPE.SYSTEM,
                        operate_type=USER_CHANGE_LOG_OPERATE_TYPE.LOGIN,
                        comment=''):
    """
    用户信息发生变更时触发
    """
    try:
        user_logger.info('[TRIG] user(%s) trigger the user_change_trigger' % (user_id))
        # record_user_change_log.delay(int(user_id), change_type, operate_type, comment)
    except:
        logging_exception()
