# coding=utf-8
"""免费招募活动相关push。"""

from datetime import datetime

from gm_types.error import ERROR as ERROR_CODES
from gm_types.gaia import FREER_RECRUITMENT_PUSH_TYPE

from rpc.decorators import bind_context, bind
from rpc.tool.error_code import gen
from rpc.tool.log_tool import logging_exception, user_logger

from api.util.user_util import simple_user_info_by_user_ids
from api.tool.user_tool import get_user_from_context
from api.models.freerecruitment import AssistanceUser
from api.models.freerecruitment import FreeRecruitment
from api.models.freerecruitment import ThirdAccountInfo

from api.services.free_recruitment_service import FreeRecruitmentPushService


@bind_context('api/freerecruitment/push')
def freerecruitment_push(ctx, activity_id, push_type, pushed_user_id, page):
    """免费招募活动相关push。

    :params activity_id:        int 活动ID
    :params push_type:          enum push类型
    :params pushed_user_id:     int 接收push的用户
    :params page:               string 落地页
    """

    user = get_user_from_context(ctx)

    if not page:
        user_logger.info("api/freerecruitment/push no page")
        return

    user_dict = simple_user_info_by_user_ids([pushed_user_id])
    pushed_user = user_dict.get(str(pushed_user_id))
    try:
        third_account_info = ThirdAccountInfo.objects.get(
            push_type=push_type, user_id=pushed_user_id, activity_id=activity_id)
    except:
        logging_exception()
        return

    extra_info = {}
    if push_type == FREER_RECRUITMENT_PUSH_TYPE.VOTED:

        hour = datetime.now().hour
        if hour < 10 or hour > 22:
            user_logger.info("api/freerecruitment/push hour is unvaild")
            return

        if not user:
            gen(ERROR_CODES.LOGIN_REQUIRED)

        if user.id == pushed_user_id:
            user_logger.info("api/freerecruitment/push user.id {} == pushed_user_id {}".format(user.id, pushed_user_id))
            return

        vote_num = AssistanceUser.objects.filter(
            freerecruitment_id=activity_id,
            user_id=pushed_user_id,
        ).count()
        extra_info["vote_num"] = vote_num
        extra_info["nick_name"] = user.last_name

    elif push_type == FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_STARTED:
        try:
            activity = FreeRecruitment.objects.get(pk=activity_id, is_online=True)
        except:
            logging_exception()
            return

        extra_info["start_time"] = activity.start_time
        extra_info["end_time"] = activity.end_time
        extra_info["activity_title"] = activity.title

    elif push_type == FREER_RECRUITMENT_PUSH_TYPE.ACTIVITY_ENDED:
        try:
            activity = FreeRecruitment.objects.get(pk=activity_id, is_online=True)
        except:
            logging_exception()
            return

        extra_info["nick_name"] = pushed_user.nick_name
        extra_info["activity_title"] = activity.title

    FreeRecruitmentPushService.send_template_msg(
        push_type, extra_info, pushed_user, page, third_account_info.form_id
    )
    user_logger.info("api/freerecruitment/push push finished")
    third_account_info.is_online=False
    third_account_info.save()
