from gm_types.gaia import SCAN_TYPE
from api.models.face.ai_target import AiTarget

from rpc.decorators import bind


@bind("api/ai_targert/get_descs")
def ai_targert_descs(parts=None, part_type=SCAN_TYPE.SCAN_FACE):
    if parts:
        objs = AiTarget.objects.filter(part__in=parts, part_type=part_type)
    else:
        objs = AiTarget.objects.filter(part_type=part_type)

    return {item.part: item.target_desc for item in objs}
