# coding=utf-8

# NOTE: deprecated
# NOTE: deprecated
# NOTE: deprecated

from __future__ import unicode_literals, absolute_import, print_function


from rpc.decorators import bind, bind_context
from api.models import ServiceFavor, Service
from django.contrib.auth.models import User
from django.db.models import Q
from rpc.tool.error_code import gen, CODES


@bind_context("api/service_favor/create")
def create_service_favor(ctx, user_id, service_id):
    try:
        user = User.objects.get(pk=user_id)
    except User.DoesNotExist:
        raise gen(CODES.USER_NOT_FOUND)
    
    try:
        service = Service.objects.get(pk=service_id)
    except Service.DoesNotExist:
        raise gen(CODES.SERVICE_NOT_EXSIT)
        
    service_favor, created= ServiceFavor.objects.get_or_create(user=user, service=service)
    return {"service_favor_id":service_favor.id}
        
    
@bind_context("api/service_favor/list")
def list_service_favor(ctx,user_id, offset, limit):
    q = Q(user_id=user_id)
    return ServiceFavor.query(q, offset, limit)


@bind_context("api/service_favor/delete")
def delete_service_favor(ctx, user_id, service_id):
    try:
        ServiceFavor.objects.get(user_id=user_id , service_id=service_id).update(is_deleted=True)
        return {}
    except ServiceFavor.DoesNotExist:
        return gen(CODES.SERVICE_FAVOR_NOT_FOUND)
