
from django.core.management import BaseCommand
from gm_types.gaia import RED_PACKET

from cashback.models import RedPacket, Dialog


class Command(BaseCommand):

    def handle(self, *args, **options):
        Dialog.objects.create(
            type=RED_PACKET.CASH,
            packet_id=RedPacket.objects.filter(
                packet_type=RED_PACKET.CASH,
                is_online=True
            ).latest('create_time').id
        )
        Dialog.objects.create(
            type=RED_PACKET.INVITE,
            packet_id=RedPacket.objects.filter(
                packet_type=RED_PACKET.INVITE,
                is_online=True
            ).latest('create_time').id
        )
