# -*- coding: UTF-8 -*-
from __future__ import unicode_literals, absolute_import, print_function
from django.db import models

from gm_types.gaia import CHANNEL_TYPE


class Channel(models.Model):
    class Meta:
        verbose_name = '渠道'
        app_label = 'channel'

    name = models.CharField(verbose_name=u'渠道名', max_length=100)
    url_name = models.CharField(verbose_name=u'路径名', max_length=100, unique=True)
    pack = models.BooleanField(verbose_name=u'是否自动打包', default=True)
    released_version = models.CharField(verbose_name=u'当前版本', max_length=20, default='')
    vendor = models.ForeignKey('ChannelVendor', verbose_name=u'所属渠道商', null=True)
    type = models.IntegerField(u'渠道类型', choices=CHANNEL_TYPE, default=CHANNEL_TYPE.TOUFANG)


class ChannelVendor(models.Model):
    class Meta:
        verbose_name = u'渠道商'
        app_label = 'channel'

    name = models.CharField(u'渠道商', max_length=100, unique=True)
    is_online = models.BooleanField(u'是否有效', default=True)
