# -*- coding: UTF-8 -*-

from django.db import models

class TopicSticky(models.Model):
    class Meta:
        verbose_name = u'社区置顶'
        db_table = 'community_topic_sticky'
        app_label = 'community'

    topic_id = models.IntegerField()
    desc = models.CharField(u'置顶描述', max_length=200, default='')
    ordering = models.IntegerField(u'排序', default=0, help_text=u'越小越靠前')
    is_online = models.BooleanField(u'是否上线', default=False)
