# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

import datetime
from django.db.models import Sum
from rpc.decorators import bind_context
from api.models import Service, ServiceItem, Shopcart
from api.models import Conversation
from hippo.tool.stats_tool import get_shopcart_amount


@bind_context("doctor/shopcart/show")
def doctor_shopcart_data(ctx, doctor_ids):
    """
    获取商户下所有医生购物车美购的总数量及总金额
    :param ctx:
    :return:
    """
    return {
        'count': Shopcart.objects.filter(service__doctor__in=doctor_ids,
                                         service__is_online=True,
                                         service_item__is_delete=False).aggregate(count=Sum('number'))['count'],
        'amount': sum([get_shopcart_amount(d) for d in doctor_ids])
    }


@bind_context("doctor/shopcart/get_conversion_id")
def doctor_get_conversion(ctx, user_ids):
    if len(user_ids) != 2:
        return ''
    try:
        obj = Conversation.objects.get(uid_hash=Conversation.gen_uid_hash(user_ids))
        return obj.id
    except:
        return ''