# coding=utf-8
from __future__ import unicode_literals
from rpc.decorators import bind_context
from api.tool.user_tool import get_doctor_from_context
from doctor.tool.switch_tool import DoctorSwitch
from api.tool.image_utils import get_full_path


@bind_context('doctor/switch/change', login_required=True)
def change_doctor(ctx, doctor_id):
    """
        切换医生
        返回切换后的session
    """
    doctor = get_doctor_from_context(ctx)
    return DoctorSwitch(ctx, doctor).do_switch(doctor_id)


@bind_context('doctor/switch/list')
def change_list(ctx):
    '''
        切换账号
    '''
    doctor = get_doctor_from_context(ctx)

    ret = []
    for doctor in DoctorSwitch(ctx, doctor).get_switch_doctors():
        ret.append({'id': doctor.id,
                    'name': doctor.name,
                    'portrait': doctor.portrait if doctor.portrait else get_full_path('img%2Fuser_portrait.png')})
    return ret
