#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/1/21

import os
from django.conf import settings
from django.core.management import BaseCommand

IMAGE_DIRS = os.path.join(settings.BASE_DIR, "pic")


def count_image_nums(path):
    """
    统计每个等级图片数目
    :param path:
    :return:
    """
    level_images_dict = {}
    for filename in os.listdir(path):
        print("filename--->", filename)
        prefix = int(filename.split('.')[0].split('_')[-1])
        if level_images_dict.get(prefix):
            level_images_dict[prefix] += 1

        else:
            level_images_dict[prefix] = 1

    return level_images_dict


class Command(BaseCommand):
    def handle(self, *args, **options):
        level_images_dict = count_image_nums(IMAGE_DIRS)
        print(level_images_dict)

