# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import itertools

from django.conf import settings


class CeleryTaskRouter(object):
    # Map[QueueName, List[TaskName]]
    queue_task_map = {
        'order': [
            'api.tasks.ping_pong_tasks.ping_order',

            'api.tasks.order_task.order_increase_event',
            'api.tasks.order_task.order_expired_reminder',
            'api.tasks.order_task.order_cancel_event',
            'api.tasks.order_task.order_decrease_event',
            'api.tasks.order_task.refund_cancle_event',
            'api.tasks.order_task.doctor_refund_timeout',

            'api.tasks.settlement_task.settlement_create_event',
            'api.tasks.settlement_task.settlement_soft_timeout_event',
            'api.tasks.settlement_task.settlement_hard_timeout_event',

            'pay.tasks.alert_task.stock_alert',
            'pay.tasks.alert_task.refund_alert',
            'pay.tasks.alert_task.remind_coupon_expire_alert',
            'pay.tasks.alert_task.period_stock_alert',

            'pay.tasks.installment_task.get_installment_repay_status',
            'pay.tasks.installment_task.monitor_xiaoying_lend_loan_callback',

            'pay.tasks.statement_task.create_all_statements',

            'pay.tasks.momo_task.get_momo_stat_log_from_db_and_send',
        ],
        'graces-dbmw': [
            'api.tasks.ping_pong_tasks.ping_dbmw',
            'injection.data_sync.tasks.write_to_es',
            'injection.data_sync.task.user_follow_sync',
            'hera.viewmodels.tasks.handle_viewmodel_sync',
            'hippo.tasks.update_merchant_by_doctor',
        ],

        'doctor-notify': [
            'api.tasks.notify.notify_push',
        ],

        'doctor-userbrowsing': [
            'api.tasks.userbrowsing.add_user_browsing',
        ],
        'momo_stat_log': [
            'api.tasks.period_task.momo_stat_log',
        ],
        'message': [
            'message.tasks.send_jim_message',
            'message.tasks.change_message_is_read_status_and_notify',
            'message.tasks.new_message_send_push',
        ],
    }

    # Map[TaskName, QueueName]
    task_queue_map = dict(itertools.chain.from_iterable(
        [(task, queue) for task in task_list]
        for (queue, task_list) in queue_task_map.items()
    ))

    def route_for_task(self, task, args=None, kwargs=None):
        if settings.DEBUG:
            return None

        if task.startswith("statistic") or task.startswith("api.tasks.export_excel_task"):
            return "slow"

        queue_name_or_none = self.task_queue_map.get(task)
        return queue_name_or_none
