# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function


from api.models import User, UserExtra
from api.tool.user_tool import filter_user_nick_name
from graphene_django import DjangoObjectType
import graphene


class UserType(DjangoObjectType):
    class Meta:
        model = User

    nickname = graphene.Field(graphene.String)

    def resolve_nickname(self, *args, **kwargs):
        if isinstance(self, UserType):
            return self.nickname
        else:
            return filter_user_nick_name(self)


class UserExtraType(DjangoObjectType):
    class Meta:
        model = UserExtra
