# coding=utf-8
from django.core.management import BaseCommand

from api.models import Order


class Command(BaseCommand):
    """
    python manage.py update_20161228_set_order_is_settled_false
    由于运营误操作将十二月份订单设置为已结算，现虚批量修改订单状态
    created by oldman 2016-12-28
    """

    def handle(self, *args, **options):
        orders = Order.objects.filter(created_time__gt='2016-12-01 00:00:00', created_time__lt='2016-12-14 00:00:00',
                                      is_settled=True)
        if orders.count() == 2307:
            orders.update(is_settled=False, settled_time=None)
            print (u'Done')
            print (u'Done')
        else:
            print(u'数量不对！')
