# -*- coding: utf-8 -*-

from gm_dataquery.dataquery import DataSQLQuery


def choice_query(model, search_fields, filter_field, q='', initial=None, orders=None, using=None):
    dqobj = DataSQLQuery(model=model, using=using)

    filters = None
    if initial is not None:
        filters = [
            {'field': filter_field, 'value': initial, 'regex': False},
        ]

    search = {
        'fields': search_fields,
        'value': q,
        'regex': True,
    }
    if orders:
        orders = [{
            'name': orders,
            'dir': 'desc'
        }]

    qs = dqobj.build_queryset(search, filters, orders=orders)
    return qs
