# coding=utf-8
from gm_types.gaia import TAG_TYPE

from api.models import ItemWiki
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from django.db.models import Q


class ItemWikiDB(DataBuilder):
    """
    项目百科实体的返回数据格式
    """

    def getval_created_time(self, obj, default=''):
        if obj.created_time:
            return str(obj.created_time)[0:19]

    def getval_tag__tag_type(self, obj):
        if obj.tag.tag_type:
            return TAG_TYPE.getDesc(obj.tag.tag_type)

    def getval_connect_wiki(self, obj):
        connect_date = u''
        for i in obj.parentwiki.all():
            connect_date += u'{}:{},'.format(i.connectwiki_id, i.connectwiki.item_name)
        return connect_date[:-1]


@DB
class ItemWikiDQ(DataSQLQuery):
    """
    项目百科实体查询过滤
    """
    model = ItemWiki
    data_model = ItemWikiDB
