# -*- coding: UTF-8 -*-

from django.db.models import Q

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.gaia import POINTS_OPERATION, POINTS_TYPE

from point.models import Points


class PointsDB(DataBuilder):

    def getval_operation(self, obj):
        return POINTS_OPERATION.getDesc(obj.operation) if obj.operation else ''

    def getval_reason(self, obj):
        return POINTS_TYPE.getDesc(obj.reason) if obj.reason else ''

    def getval_user(self, obj):
        return obj.user.last_name if obj.user else ''


@DB
class PointsDQ(DataSQLQuery):
    model = Points
    data_model = PointsDB

    def filter_add_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
