# -*- coding: UTF-8 -*-

import time,datetime
from api.models import SeoDigest,SeoCategory,FriendlySite,InnerHyperlink
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.gaia import CATEGORY_TYPE


class SeoDigestDB(DataBuilder):
    def getval_seo_name(self, obj):
        return obj.seo_category.name

    def getval_create_time(self, obj):
        time_format = datetime.datetime.strftime(obj.create_time, '%Y-%m-%d %H:%M:%S')
        return time_format


@DB
class SeoDigestDQ(DataSQLQuery):
    model = SeoDigest
    data_model = SeoDigestDB


class SeoCategoryDB(DataBuilder):
    def getval_seo_name(self, obj):
        return obj.seo_category.name

    def getval_category_type(self, obj):
        return CATEGORY_TYPE.getDesc(obj.category_type)


@DB
class SeoCategoryDQ(DataSQLQuery):
    model = SeoCategory
    data_model = SeoCategoryDB


class FriendlySiteDB(DataBuilder):
    pass


@DB
class FriendlySiteDQ(DataSQLQuery):
    model = FriendlySite
    data_model = FriendlySiteDB


class InnerHyperlinkDB(DataBuilder):
    pass


@DB
class InnerHyperlinkDQ(DataSQLQuery):
    model = InnerHyperlink
    data_model = InnerHyperlinkDB
