# -*- coding: UTF-8 -*-
import json
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from api.models import ServiceComment


class ServiceCommentDB(DataBuilder):
    def getval_user_name(self, obj):
        return {
            'id': obj.order.user_id,
            'text': obj.order.user.last_name,
        }

    def getval_has_image(self, obj):
        return True if obj.image.count() else False

    def getval_content(self, obj):
        return obj.content[:100] + '...' if len(obj.content) > 100 else obj.content


@DB
class ServiceCommentDQ(DataSQLQuery):
    model = ServiceComment
    data_model = ServiceCommentDB
