# coding=utf-8
from api.models import Tag
from api.models import TagAttr
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery


class TagAttrsDB(DataBuilder):
    """
    美购待审核实体的返回数据格式
    """

    def getval_attr1(self, obj):
        attrs = TagAttr.objects.filter(tag_id=obj.id)
        if len(attrs) > 0:
            return attrs[0].name

    def getval_attr2(self, obj):
        attrs = TagAttr.objects.filter(tag_id=obj.id)
        if len(attrs) > 1:
            return attrs[1].name

    def getval_attr3(self, obj):
        attrs = TagAttr.objects.filter(tag_id=obj.id)
        if len(attrs) > 2:
            return attrs[2].name


class TagAttrsDQ(DataSQLQuery):
    """
    美购待审核实体查询过滤
    """
    model = Tag
    data_model = TagAttrsDB
