# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from api.models import UploadButton
from datetime import datetime


class UploadButtonDB(DataBuilder):
    def getval_button_prefix(self, obj, default=''):
        return obj.button_prefix


@DB
class UploadButtonDQ(DataSQLQuery):
        model = UploadButton
        data_model = UploadButtonDB

        def filter_start_show_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_end_show_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_start_sell_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_end_sell_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)
