#! /usr/bin/env python
# -*- coding: utf-8 -*-
# create by oldman
# Date: 2019/3/19
from django.db.models import Q

from hera.queries.merchant import MerchantRelatedInfoDQ
from hera.utils import get_business_team
from rpc.decorators import bind_context

uri_pre = 'hera/merchant/'




@bind_context(uri_pre + 'related_info_query')
def order_query(ctx, options):
    init_q = Q(is_online=True)
    _in, businessman_list, team_groups = get_business_team(ctx)

    if _in:
        busines_q = Q(doctor__business_partener__in=businessman_list) | Q(doctor__business_group__in=team_groups)
    else:
        busines_q =  Q()
    init_q  = init_q & busines_q

    dtobj = MerchantRelatedInfoDQ(init_q=init_q)
    return dtobj.process(**options)