# -*- coding: UTF-8 -*-

from rpc.decorators import bind_context
from hippo.models.record import PhoneRecord
from ..datatables import PhoneRecordDT

from ..queries.phonerecord import PhoneRecordDQ


uri_pre = 'hera/phonerecord'


@bind_context(uri_pre + '/query')
def phonerecord_query(ctx, options):
    dqobj = PhoneRecordDQ()
    return dqobj.process(**options)


@bind_context(uri_pre+'/list')
def phonerecord_datatable(ctx, req_data):
    dtobj = PhoneRecordDT(PhoneRecord)
    return dtobj.process(req_data)
