#! /usr/bin/env python
# -*- coding: utf-8 -*-
# create by oldman
# Date: 2019/2/26
import tablib
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api import Service
from api.models import User
from hippo.models import Doctor
from hera.management.commands.utils import get_mail

excel_info = {}
def do_excel():
    wb = load_workbook(filename='cpc.xlsx')
    sheetnames = wb.get_sheet_names()
    ws = wb.get_sheet_by_name(sheetnames[0])
    for rx in range(2, ws.max_row + 1):
        request_id = ws.cell(row=rx, column=1).value
        service_id = ws.cell(row=rx, column=2).value
        cost = ws.cell(row=rx, column=3).value
        cpc_created_time = ws.cell(row=rx, column=4).value
        service_doctor_id = ws.cell(row=rx, column=5).value
        merchant_id = ws.cell(row=rx, column=6).value
        user_id = ws.cell(row=rx, column=7).value
        try:
            user = User.objects.get(id=user_id)
            user_name = user.last_name
        except:
            user_name = ''

        try:
            service = Service.objects.get(id=service_id)
            service_name = service.name
        except:
            service_name = ''
        try:
            doctor = Doctor.objects.get(id=service_doctor_id)
            doctor_name = doctor.name
            hospital_id = doctor.hospital.id if doctor.hospital else ''
            hospital_name = doctor.hospital.name if doctor.hospital else ''
        except:
            doctor_name = ''
            hospital_id=''
            hospital_name = ''
        excel_info[request_id]={
            'service_id': service_id,
            'cost': cost,
            'cpc_created_time': cpc_created_time,
            'service_doctor_id': service_doctor_id,
            'merchant_id': merchant_id,
            'user_id':user_id,
            'user_name': user_name,
            'service_name': service_name,
            'doctor_name': doctor_name,
            'hospital_id': hospital_id,
            'hospital_name': hospital_name
        }

class Command(BaseCommand):
    """
    python manage.py export_2019_02_26_cpc_click_data
    """

    def handle(self, *args, **options):
        do_excel()
        dt = tablib.Dataset()
        dt.headers = (
        u'用户ID', u'用户名', u'美购id',u'美购名', u'cpc扣费时间', u'cpc扣费金额', '医生ID', '医生名','医院ID', '医院名','商户Id','请求ID', '')
        for request_id, values in excel_info.items():
            x = (
                values['user_id'],
                values['user_name'],
                values['service_id'],
                values['service_name'],
                values['cpc_created_time'],
                values['cost'],
                values['service_doctor_id'],
                values['doctor_name'],
                values['hospital_id'],
                values['hospital_name'],
                values['merchant_id'],
                request_id
            )
            dt.append(x)
            get_mail(u'cpc扣费信息.xlsx', u'cpc扣费信息.xlsx', u'lipeng@igengmei.com', dt.xlsx).send()