# coding=utf-8
# create by oldman at 2018/5/15
import math

from django.conf import settings
from django.core.management import BaseCommand

from hippo.models import BusinessData


class Command(BaseCommand):
    """
     python manage.py update_2018_05_15_async_pv_xishu
    """

    def handle(self, *args, **options):
        businessdatas = BusinessData.objects.all()
        count = businessdatas.count()
        begin = 0
        step = 1000
        rate = settings.PV_RATE
        while begin <= count:
            for businessdata in businessdatas[begin:begin + step]:
                try:
                    print businessdata.id
                    businessdata.service_pv = int(math.ceil(businessdata.service_pv * rate))
                    businessdata.hospital_doctor_pv = int(math.ceil(businessdata.hospital_doctor_pv * rate))
                    businessdata.diary_pv = int(math.ceil(businessdata.diary_pv * rate))
                    businessdata.save()
                except:
                    continue
            begin += step
