# -*- coding: utf-8 -*-
# @Time    : 2019/9/9 2:17 PM
# @Author  : Esse
# @FileName: update_20190909_qucik_reply.py

from django.core.management import BaseCommand
from hippo.models.config import DoctorQuickReplay
from hippo.models.doctor import Doctor
from hippo.models.quick_reply import QucikReplyContent, QuickReplyGroup


class Command(BaseCommand):
    """
    更新医生回复到新表
    python manage.py update_20190909_qucik_reply
    """

    def handle(self, *args, **options):
        # 为所有医生创建默认分组
        ds = Doctor.objects.all()
        for d in ds:
            QuickReplyGroup.objects.get_or_create(doctor_id=d.id, name=u'默认分组', rank=0)
            print(d.id)
        print('-----Group created!!!-----')
        qrs = DoctorQuickReplay.objects.all()
        # 将已有回复全部更新到新表，并关联到默认分组
        for qr in qrs:
            group = QuickReplyGroup.objects.filter(doctor_id=qr.doctor_id).first()
            rank = QucikReplyContent.objects.filter(quickreplygroup_id=group.id).count()
            QucikReplyContent.objects.create(quickreplygroup_id=group.id, name=qr.content, rank=rank)
            print(qr.doctor_id)
