#!/usr/bin/env python
# coding=utf-8

from django.db import models

from .doctor import Doctor


class DoctorQuickReplay(models.Model):
    class Meta:
        verbose_name = u"医生私信快捷回复"
        db_table = 'doctor_quickreplay'

    doctor = models.ForeignKey(Doctor, verbose_name=u"医生")
    content = models.CharField(verbose_name=u"自定义快捷回复内容", max_length=300, null=False, blank=False)
    stick_time = models.DateTimeField(verbose_name=u"点击置顶时间", null=False, blank=False)
    deleted = models.BooleanField(verbose_name=u"是否被医生已删除", null=False, blank=False, default=False)


class DoctorWhiteList(models.Model):
    class Meta:
        verbose_name = u'医生白名单'
        verbose_name_plural = u'医生白名单'
        db_table = 'api_doctorwhitelist'
        app_label = 'api'

    doctor = models.ForeignKey(Doctor, blank=False, verbose_name=u"医生")
