from django.conf import settings
from gm_dbmw_api.descriptor.connection import Connection, _TaskGroupCategory
from gm_dbmw_api.descriptor.sink import CeleryV1Sink
from gm_dbmw_api.descriptor.source import MySQLTableScanSource
from gm_dbmw_api.descriptor.source import MySQLTableSource

from injection.data_sync.utils import ConnectionCreaterBase


class UserFollowConnection(ConnectionCreaterBase):

    def __init__(self, base_dir, queue_name):
        self.conn_name = "user_follow"
        super(UserFollowConnection, self).__init__(self.conn_name, base_dir, queue_name)

    @property
    def sink(self):
        return CeleryV1Sink(
            task='injection.data_sync.tasks.user_follow_sync',
            key_list_param_name='ids',
            static_params_json='{}',
            broker_url=settings.BROKER_URL,
            queue=self.queue_name,
            unpack_input_tuple=True,
            batch_size_limit=20,
            flow_rate_limit=20.0,
            push_rate_limit=3.0,
            preferred_batch_size=20,
            linger_seconds=3,
        )

    def online_connection(self):
        return Connection(
            name='%s_online' % self.conn_name,
            sink=self.sink,
            task_group_category=_TaskGroupCategory.ONLINE,
            source=MySQLTableSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name='social_userfollow',
                key_columns=['id'],
                value_columns_all=True,
            )
        )

    def round_connection(self):
        return Connection(
            name='%s_round' % self.conn_name,
            sink=self.sink,
            task_group_category=_TaskGroupCategory.ROUND_SCANNING,
            source=MySQLTableScanSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name='social_userfollow',
                key_columns=['id'],
                reversed_scanning=True,
                cyclic=True,
                scan_rate=15,
            )
        )

    def full_connection(self):
        return Connection(
            name='%s_full' % self.conn_name,
            sink=self.sink,
            task_group_category=_TaskGroupCategory.FULL_SCANNING,
            source=MySQLTableScanSource(
                logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                table_name='social_userfollow',
                key_columns=['id'],
            )
        )
