# coding=utf-8
import os

from django.core.management import BaseCommand

from lasker.models import Participant, Vote


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('-f', '--file', help=u"医生机构管理者的ID列表")

    def handle(self, *args, **options):
        fp = options['file']
        if os.path.isfile(fp):
            with open(fp) as f:
                for line in f:
                    queryset = Participant.objects.filter(doctor_id=line.strip())
                    for participant in queryset:
                        participant.votes.all().delete()
                        participant.delete()
        else:
            self.stdout.write("Invalid file path.")

