# coding=utf8
# 只做老接口兼容
from __future__ import absolute_import, unicode_literals

from rpc.cache import wechatpub_cache
from rpc.decorators import bind


@bind('message/wechatpub/finish_conversation')
def wechatpub_finish_conversation(user_id, doctor_user_id):
    k = 'wx_forbidden:%s:%s' % (doctor_user_id, user_id)
    wechatpub_cache.setex(k, 2 * 24 * 60 * 60, 1)
    return {'updated': True}


@bind('message/wechatpub/start_conversation')
def wechapub_start_conversation(user_id, doctor_user_id):
    key = 'wx_forbidden:%s:%s' % (doctor_user_id, user_id)
    wechatpub_cache.delete(key)
