# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models

from api.models import Settlement
from pay.manager import AlipaySettlementManager

class AlipayRefund(models.Model):
    class Meta:
        verbose_name = '支付宝退款'
        verbose_name_plural = '支付宝退款'
        db_table = 'pay_alipayrefund'
        app_label = 'pay'

    # 所有平台均有
    order_no = models.CharField(max_length=12, verbose_name='订单号', help_text='gaia order')
    refund_fee = models.IntegerField(default=0)
    created_at = models.DateTimeField(auto_now_add=True, verbose_name="创建时间")
    # 支付宝平台特有
    trade_no = models.CharField(max_length=64, verbose_name="原付款支付宝交易号")
    trade_status = models.CharField(max_length=64, verbose_name="交易状态")
    notify_id = models.TextField(verbose_name="notify_id")
    batch_no = models.TextField(verbose_name="支付宝退款批次号")


class AlipaySettlement(models.Model):
    class Meta:
        verbose_name = '支付宝结单附加信息'
        db_table = 'pay_alipaysettlement'
        app_label = 'pay'

    settlement = models.ForeignKey(Settlement, verbose_name='关联的结算单')
    trade_no = models.CharField(max_length=64, null=True, blank=True, verbose_name='支付宝交易号')
    trade_status = models.CharField(max_length=32, null=True, blank=True, verbose_name='支付宝交易状态')
    origin_data = models.TextField(null=True, blank=True, verbose_name='原始支付信息')
    buyer_id = models.CharField(max_length=30, null=True, blank=True, verbose_name='买家ID')
    buyer_email = models.EmailField(null=True, blank=True, verbose_name='买家Email')
    total_fee = models.FloatField(null=True, blank=True, verbose_name='付款总额')
    gmt_create = models.DateTimeField(null=True, blank=True, verbose_name='订单生成时间')
    gmt_payment = models.DateTimeField(null=True, blank=True, verbose_name='订单付款时间')
    created_time = models.DateTimeField(auto_now_add=True, help_text=u"创建时间")

    objects = AlipaySettlementManager()
