# coding=utf-8
from __future__ import unicode_literals, absolute_import
import datetime

from django.db import models
from django.db.models import base

from api.models.types import (
    PAYMENT_TYPE,
    SERVICE_CHANNEL,
    SERVICE_FLAG,
)
from api.models import BodyPartSubItem
from api.models import Doctor
from api.models import Service
from api.models import Order
from api.models import Hospital
from api.models import ItemWiki
from api.models import User
from api.models import Special

from api.models import SpecialSeckillService, DoctorSeckillApply

from pay.manager import ServiceSnapshotManager

from gm_types.gaia import COUPON_TYPES, SERVICE_SELL_TYPE


class ServiceSnapshot(models.Model):
    class Meta:
        db_table = 'pay_servicesnapshot'
        app_label = 'pay'

    order = models.OneToOneField(Order, related_name='servicesnapshot')
    service = models.ForeignKey(Service, verbose_name='美购', on_delete=models.DO_NOTHING)
    name = models.CharField(max_length=100, null=False, verbose_name='福利名称')
    short_description = models.CharField(max_length=100, null=False, verbose_name='一句话描述')
    detail_description = models.TextField(max_length=2000, verbose_name='详细描述')
    exchange_points_ceiling = models.IntegerField(verbose_name='最多可抵用积分')
    doctor = models.ForeignKey(Doctor, null=True, on_delete=models.DO_NOTHING)

    hospital = models.ForeignKey(Hospital, verbose_name='关联的医院', null=True, on_delete=models.DO_NOTHING)
    special_remind = models.TextField(max_length=1000, null=True, verbose_name='特别提醒')
    ceiling_price = models.IntegerField(verbose_name='最高价', default=999999)
    payment_type = models.CharField(verbose_name='付款模式', max_length=1, choices=PAYMENT_TYPE,
                                    default=PAYMENT_TYPE.FULL_PAYMENT)
    channel = models.CharField(verbose_name='福利频道', max_length=1, choices=SERVICE_CHANNEL,
                               default=SERVICE_CHANNEL.SPECIAL_OFFER)
    service_flag = models.CharField(verbose_name='福利标记', max_length=1, choices=SERVICE_FLAG,
                                    default=SERVICE_FLAG.DOCTOR)
    phone = models.CharField(max_length=20, null=True, blank=True, verbose_name='服务电话')
    sms_phone = models.CharField(max_length=10, null=True, blank=True, verbose_name='短信通知号码')
    pm_content = models.TextField(max_length=1000, null=True, blank=True, verbose_name='医生私信内容')
    address = models.CharField(max_length=100, null=True, blank=True, verbose_name='服务地址')
    is_online = models.BooleanField(default=False, help_text="是否上线", verbose_name="上线")
    is_sale = models.BooleanField(default=True, help_text='是否在售', verbose_name='是否在售(当前仅用于排序规则)')
    is_voucher = models.BooleanField(default=False, help_text='是否是代金券', verbose_name='是否是代金券类型')
    ordering = models.IntegerField(default=100, verbose_name="展示顺序", help_text="小的排在前，大的排在后")
    sell_num_limit = models.IntegerField(verbose_name='可售数量限制', default=999999)
    total_num = models.IntegerField(verbose_name="总数量")
    start_time = models.DateTimeField(verbose_name='福利起始时间')
    end_time = models.DateTimeField(null=True, blank=True, verbose_name="福利结束时间")
    update_time = models.DateTimeField(verbose_name="最近修改时间")
    is_floor_price = models.BooleanField(verbose_name='是否底价')

    only_use_points = models.BooleanField(verbose_name='只能用积分购买', default=False, null=False, blank=False)
    single_user_buy_limit = models.IntegerField(default=10, verbose_name='单个用户购买数量限制')
    need_address = models.BooleanField(verbose_name='需要地址', default=False)
    need_sms_alert = models.BooleanField(verbose_name='需要短信提醒', default=True)
    bodypart_subitem = models.ForeignKey(BodyPartSubItem,
                                         default=None, null=True, verbose_name="项目类别", on_delete=models.DO_NOTHING)
    image_header = models.CharField(max_length=300, help_text="福利顶部图片", verbose_name='图片地址', default='')
    image_detail = models.CharField(max_length=300, help_text="福利详情图片", verbose_name='图片地址', default='', blank=True)
    is_multiattribute = models.BooleanField(help_text="是否多属性福利", verbose_name="是否多属性福利", default=False)
    share_get_cashback = models.BooleanField(help_text="是否支持分享返现", verbose_name="是否支持分享返现", default=False)
    refund_anytime = models.BooleanField(help_text="是否支持随时退款", verbose_name="是否支持随时退款", default=False)
    compensation_in_advance = models.BooleanField(help_text="是否支持先行赔付", verbose_name="是否支持先行赔付", default=False)
    cash_back_rate = models.IntegerField(verbose_name='返现百分比', default=5)
    fake_sold_num = models.IntegerField(verbose_name='已抢购基数', default=0)
    notes = models.CharField(max_length=300, help_text="备注", default="", null=True, blank=True, verbose_name='备注')
    show_location = models.BooleanField(help_text="是否显示地理位置", verbose_name="是否显示地理位置", default=True)
    tip = models.CharField(max_length=128, null=False, verbose_name='提示标签', default='')

    rating = models.FloatField(verbose_name='评价', blank=True, default=0)
    operation_effect_rating = models.FloatField(verbose_name='术后效果评分',
                                                blank=True, default=0)
    doctor_attitude_rating = models.FloatField(verbose_name='医生态度评分',
                                               blank=True, default=0)
    hospital_env_rating = models.FloatField(verbose_name='医院环境评分',
                                            blank=True, default=0)
    is_operation = models.BooleanField('是否手术类', default=False)
    is_vouchsafe = models.BooleanField('是否特惠', default=False)

    special = models.ForeignKey(Special, null=True, blank=True)
    special_active = models.BooleanField('专场是否活跃', default=False)

    wiki = models.ForeignKey(
        ItemWiki, verbose_name='百科',
        help_text='一个service只有一个wiki',
        null=True,
        on_delete=models.DO_NOTHING
    )
    is_stage = models.BooleanField(help_text='是否支持分期付款', verbose_name='是否支持分期付款', default=False)

    reservation = models.IntegerField(help_text="提前预约天数", verbose_name="提前预约天数", default=1)

    valid_duration = models.IntegerField(default=180, blank=False, null=True, verbose_name='订单有效期')
    points_deduction_percent = models.IntegerField(verbose_name='积分抵用百分比(*100)', default=10)

    # added at 5.7
    recommend_usecase = models.BooleanField(verbose_name='案列推荐', default=False)

    # 自营相关
    is_self_support = models.BooleanField(verbose_name='是否自营', default=False)
    is_insurance = models.BooleanField(verbose_name=u'是否支持保险', default=False)
    # 非service snapshot
    items = models.TextField(verbose_name="名称")
    item_key = models.CharField(max_length=40, verbose_name="标识符")  # serviceitem.key

    # 多属性覆盖
    self_support_discount = models.IntegerField(verbose_name='自营抽成', default=0)
    discount = models.IntegerField(verbose_name='抽成', default=999999)
    pre_payment_price = models.IntegerField(verbose_name='预付款', default=999999)
    total_price = models.IntegerField(verbose_name='实付金额', default=999999, help_text='实际需要支付的金额')
    original_price = models.IntegerField(verbose_name='市场价', default=999999)
    gengmei_price = models.IntegerField(verbose_name='更美价', default=999999)
    cash_back_fee = models.IntegerField(verbose_name='返现金额', default=0)
    special_seckill_service = models.ForeignKey(SpecialSeckillService, null=True, verbose_name="秒杀美购",
                                                on_delete=models.DO_NOTHING)
    doctor_seckill_apply = models.ForeignKey(DoctorSeckillApply, null=True, verbose_name="专场价格",
                                             on_delete=models.DO_NOTHING)
    max_gengmei_price = models.IntegerField(verbose_name='最高更美价', default=999999)
    business_partener = models.ForeignKey(User, null=True, verbose_name=u'负责此医生的商务同事', on_delete=models.DO_NOTHING)
    business_partener_at_paid = models.ForeignKey(User, null=True, related_name='business_partener_at_paid',
                                                  verbose_name=u'在订单支付成功时负责此医生的商务同事', on_delete=models.DO_NOTHING)
    business_partener_at_validate = models.ForeignKey(User, null=True, related_name='business_partener_at_validate',
                                                      verbose_name=u'在订单验证时负责此医生的商务同事', on_delete=models.DO_NOTHING)
    cost_price = models.IntegerField(verbose_name=u'成本', default=0)

    price_info = models.TextField(verbose_name="价格信息")
    coupon_info = models.TextField(verbose_name="美券信息")

    rich_text = models.TextField(verbose_name=u'图文详情', max_length=20000, null=True, blank=True)

    coupon_id = models.IntegerField(verbose_name=u'美劵Id', null=True, blank=True, )
    coupon_info_id = models.IntegerField(verbose_name=u'美劵信息Id', null=True, blank=True, )
    coupon_name = models.CharField(null=True,max_length=15, verbose_name='美券名称')
    coupon_value = models.FloatField(null=True,verbose_name=u'美劵抵扣', default=0)
    coupon_type = models.IntegerField(choices=COUPON_TYPES, default=COUPON_TYPES.PLATFORM)
    payment_without_coupon = models.FloatField(null=True,verbose_name=u'美券抵扣前的付款额')

    coupon_gengmei_percent = models.IntegerField(verbose_name=u'抵扣金额更美承担比例', null=True, blank=True, )
    coupon_gengmei_value = models.IntegerField(verbose_name=u'更美承担金额', null=True, blank=True, )
    coupon_doctor_value = models.IntegerField(verbose_name=u'医生承担金额', null=True, blank=True, )

    invite_code = models.CharField(verbose_name='邀请码', max_length=20, null=True)
    service_type = models.IntegerField(verbose_name=u'美购类型', default=SERVICE_SELL_TYPE.NORMAL, choices=SERVICE_SELL_TYPE)

    objects = ServiceSnapshotManager()
