# coding=utf-8

from __future__ import unicode_literals
from django.conf import settings
from gm_types.gaia import SLIDE_TYPE
import urlparse
from gm_protocol import GmProtocol, GmdoctorProtocol

__author__ = 'leaf'


class PushUrlProtocol(object):
    APP_HOME = 'gengmei://home?page=home'
    ZONE_HOME = 'gengmei://home?page=zone_home'
    PRI_MSG_LIST = 'gengmei://message_list'
    NEW_TOPIC_HOVER = 'gengmei://create_topic'
    COMMENT_LIST = 'gengmei://comment_list'

    ORDER_DETAIL = 'gengmei://order_detail?order_id={id}'
    DIARY_DETAIL = 'gengmei://diary?diary_id={id}'
    TOPCI_DETAIL = 'gengmei://topic?topic_id={id}'
    ARTICLE_DETAIL = 'gengmei://article?article_id={id}'
    PROMOTION_DETAIL = 'gengmei://service?service_id={id}'
    PROMOTION_SPECIAL = 'gengmei://welfare_special?service_id={id}'

    WEB_URL = 'gengmei://common_webview?url={url}'
    ZONE_SINGLE = 'gengmei://zone?zone_id={id}'  # 似乎只有推送使用?
    SPECIAL = 'gengmei://welfare_special?service_id={id}'
    TAG = 'gengmei://zone_detail?tag_id={id}&name={name}'
    SERVICE_LIST = 'gengmei://service_list?service_channel={channel_id}&section_id={section_id}&title={title}'
    SERVICE_LIST_WITH_TAG = 'gengmei://service_list?service_channel={channel_id}&tag_id={tag_id}&title={title}'

    DOCTOR_COMMENT_LIST = 'gmdoctor://home?page=msg&tab=comment'
    DOCTOR_COMMENT_LIST2 = 'gmdoctor://comment_list'  # 新版
    DOCTOR_PRI_MSG_LIST = 'gmdoctor://home?page=msg&tab=chat'
    # 医生邀请问答
    DOCTOR_QA_INVITE_ANSWER = 'gmdoctor://qa_invite_answer'

    FANS_LIST = 'gengmei://follow_fans?type=fans&user_id={user_id}'

    SETTLEMENT_DETAIL = 'gengmei://settlement_detail?id={id}'
    SETTLEMENT_DETAIL_GIFT_EXCHANGE = 'gengmei://gift_settlement_detail?id={id}'

    FEEDBACK_DETAIL = 'gengmei://feedback_detail?id={id}'

    ACTIVITY_DETAIL = 'gengmei://activity_detail?id={id}'

    UPDATE_DIARY_OPERATION = 'gengmei://update_diary_operation?diary_id={id}'

    DOCTOR_RESERVATION_LIST = 'gmdoctor://reserve_list?reservation_type={}&status={}'
    # 邀请好友
    INVITE_FRIENDS = 'gengmei://common_webview?url=%s' % urlparse.urljoin(
        'http://backend.igengmei.com', '/hybrid/invitation/my_invitation')
    # 我的积分
    MY_POINTS = 'gengmei://personal_point_rule'
    # 秒杀
    SECKILL = 'gengmei://common_webview?url=%s' % urlparse.urljoin(
        'http://m.igengmei.com', '/activity/promotion/1024/seckill')
    # 大促美券页
    ANNIVERSARY_COUPON = 'gengmei://anniversary_coupon'
    # 大促聚合页
    PROMOTION_GROUP = 'gengmei://welfare_promotion'

    # 首页-》我
    MY_INFO = 'gengmei://home?page=personal'
    LIVE_PLAYER = 'gengmei://live_player?channel_id={id}'

SLIDE2PROTOCOL = {
    SLIDE_TYPE.SERVICE: PushUrlProtocol.PROMOTION_DETAIL,  # 美购详情
    SLIDE_TYPE.SPECIAL: PushUrlProtocol.SPECIAL,  # 美购专题
    SLIDE_TYPE.ACTIVITY: PushUrlProtocol.ACTIVITY_DETAIL,  # 活动详情
    SLIDE_TYPE.SECKILL: PushUrlProtocol.SECKILL,  # 秒杀
    SLIDE_TYPE.TAG: PushUrlProtocol.TAG,  # 圈子详情
    SLIDE_TYPE.ZONE_SINGLE: PushUrlProtocol.TAG,  # 圈子详情
    SLIDE_TYPE.DIARY: PushUrlProtocol.DIARY_DETAIL,  # 日记本详情
    SLIDE_TYPE.TOPIC: PushUrlProtocol.TOPCI_DETAIL,  # 帖子详情
    SLIDE_TYPE.URL: PushUrlProtocol.WEB_URL,  # 一般webview网页
    SLIDE_TYPE.ANNIVERSARY_COUPON: PushUrlProtocol.ANNIVERSARY_COUPON,
    SLIDE_TYPE.INVITE: PushUrlProtocol.INVITE_FRIENDS,
    SLIDE_TYPE.MY_POINTS: PushUrlProtocol.MY_POINTS,
    # 以下仅在轮播图中出现, 不使用于单排横划和固定模板
    SLIDE_TYPE.PROMOTION_GROUP: PushUrlProtocol.PROMOTION_GROUP,
    SLIDE_TYPE.ZHIBO: PushUrlProtocol.LIVE_PLAYER
}

gm_protocol = GmProtocol(settings.BACKEND_API_HOST + '/')
# 医生端协议
gmdoctor_protocol = GmdoctorProtocol()
