# -*- coding: utf8 -*-

"""
get information from talos system.
"""

from __future__ import unicode_literals, absolute_import, print_function

from gm_types.gaia import INDEX_CARD_TYPE

from rpc.all import get_rpc_remote_invoker
from api.tool.user_tool import filter_user_nick_name
from api.models import User
from rpc.tool.log_tool import logging_exception


def diary_filter(filters=None, order_by=None, offset=0, limit=10, simple=True, with_count=False):
    params = {'offset': offset, 'limit': limit, 'simple': simple, 'with_count': with_count}
    if filters:
        params['filters'] = filters
    if order_by:
        params['order_by'] = order_by
    r = get_rpc_remote_invoker()
    result = r['diary/filter'](**params).unwrap()
    return result


def diary_count(user_id):
    result = diary_filter(filters={'user_id': user_id}, with_count=True)
    return result.get('total_count', 0)


def topic_filter(and_filter=None, or_filter=None, order_by=None, values=None, limit=10, is_count=False):
    kw = locals()
    r = get_rpc_remote_invoker()
    result = r['topic/simple_filter'](**kw).unwrap()
    return result


def topic_count(user_id):
    r = get_rpc_remote_invoker()
    result = r['topic/count'](user_id=user_id).unwrap()
    return result


def topic_reply_filter(and_filter=None, or_filter=None, order_by=None, values=None, limit=10, is_count=False):
    kw = locals()
    r = get_rpc_remote_invoker()
    result = r['topic/topic_reply/filter'](**kw).unwrap()
    return result


def topic_reply_get_reply_info_by_ids(ids=None):
    ids = ids if ids else []  # 传过来空 django.db.models.query.ValuesQuerySet，报错
    r = get_rpc_remote_invoker()
    res = r['topic/topic_reply/get_reply_info_by_ids'](ids=ids).unwrap() if ids else []
    for d in res:
        user = User.objects.filter(id=d['data']['uid']).first()
        d['data']['nickname'] = filter_user_nick_name(user)
    result = [dic['data'] for dic in res]
    return result


def topic_reply_update_reply_num_by_ids(ids=[], is_online=False):
    r = get_rpc_remote_invoker()
    result = r['topic/topic_reply/update_reply_num_by_ids'](ids=ids, is_online=is_online).unwrap() if ids else []
    return result


def diary_num_and_cover_by_id(id=None):
    r = get_rpc_remote_invoker()
    res = r['diary/get_num_and_cover_by_ids'](ids=[id]).unwrap() if id else []
    result = res[0].get('data') if res else []
    return result


def diary_num_and_cover_by_ids(ids=[]):
    r = get_rpc_remote_invoker()
    result = r['diary/get_num_and_cover_by_ids'](ids=ids).unwrap() if ids else []
    return result


def diary_cover_cache_clear_by_id(id=None):
    r = get_rpc_remote_invoker()
    result = r['talos/diary/cover_cache_clear_by_ids'](ids=[id]).unwrap() if id else []
    return result


def diary_get_diary_info_by_ids(ids=[], simple=False):
    # "原user参数去掉"
    r = get_rpc_remote_invoker()
    result = r['diary/get_diary_info_by_ids'](ids=ids, simple=simple).unwrap() if ids else []
    return result


def diary_update_doctor_messages_status(ids, data_type=INDEX_CARD_TYPE.QUESTION, status=False):
    """更新医生后台医生消息的日记贴和问题列表。"""

    r = get_rpc_remote_invoker()
    try:
        result = r['diary/doctor_diary_question/status'](data_ids=ids, data_type=data_type, status=status).unwrap() if ids else []
    except:
        logging_exception()


def topic_get_tags_by_id(id=None):
    r = get_rpc_remote_invoker()
    res = r['topic/get_tags_by_topic_ids'](ids=[id]).unwrap() if id else []
    result = res[0].get('data') if res else []
    return result


def topic_get_tags_by_ids(ids=[]):
    r = get_rpc_remote_invoker()
    result = r['topic/get_tags_by_topic_ids'](ids=ids).unwrap() if ids else []
    return result


def topic_vote_amount_by_id(id=None):
    r = get_rpc_remote_invoker()
    res = r['topic/get_topic_num_by_ids'](ids=[id]).unwrap() if id else []
    result = res[0].get('data') if res else []
    return result


def topic_vote_amount_by_ids(ids=[]):
    r = get_rpc_remote_invoker()
    result = r['topic/get_topic_num_by_ids'](ids=ids).unwrap() if ids else []
    return result


def topic_get_topic_info_by_id(id=None, user_id=None):
    r = get_rpc_remote_invoker()
    res = r['topic/get_topic_info_by_ids'](ids=[id], user_id=user_id).unwrap() if id else []
    result = res[0].get('data') if res else []
    return result


def topic_update_reply_num_by_id(id=None, is_online=False):
    r = get_rpc_remote_invoker()
    result = r['topic/update_reply_num_by_ids'](ids=[id], is_online=is_online).unwrap() if id else []
    return result


def topic_update_reply_num_by_ids(ids=[], is_online=False):
    r = get_rpc_remote_invoker()
    result = r['topic/update_reply_num_by_ids'](ids=ids, is_online=is_online).unwrap() if ids else []
    return result


def topic_info_for_doctor_notification(topic_id):
    r = get_rpc_remote_invoker()
    try:
        result = r['topic/info_for_doctor_notification'](topic_id=topic_id).unwrap()
    except:
        logging_exception()
        return None
    return result

# todo 无调用 180315
# def get_service_related_diary_amount(service_id):
#     r = get_rpc_remote_invoker()
#     try:
#         result = r['talos/diary/service_related_diary_amount'](service_id=service_id).unwrap()
#     except:
#         logging_exception()
#         return 0
#     return result


def get_diary_info_for_es_query(diary_ids, user_id):
    r = get_rpc_remote_invoker()
    try:
        result = r['topic/diary/for_es_query'](diary_ids=diary_ids, user_id=user_id).unwrap()
    except:
        logging_exception()
        return []
    return result


def get_order_has_diary_and_topics(order_id):
    r = get_rpc_remote_invoker()
    result = r['diary/order'](order_id=order_id).unwrap()
    return result
