from rpc.decorators import bind
from django.conf import settings
from django.core.mail import EmailMultiAlternatives, get_connection

connection = get_connection(
    username=settings.HERA_EMAIL_USER,
    password=settings.HERA_EMAIL_PSWD,
)


@bind('internal_email/send')
def email_send(to, subject='', text=None, html=None, from_name='bot'):
    mail = EmailMultiAlternatives(
        subject=subject,
        to=to,
        from_email='{} <{}>'.format(from_name, settings.HERA_EMAIL_USER),
        connection=connection
    )
    if text is not None:
        mail.body = text
    if html is not None:
        mail.attach_alternative(html, "text/html")
    mail.send()
