-- Deploy gaia:2017_09_28_add_payment_order to mysql
BEGIN;

CREATE TABLE `pay_paymentorder` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `total_fee` integer NOT NULL,
    `third_user_account` varchar(100),
    `channel` varchar(10),
    `out_trade_no` varchar(32),
    `transaction_id` varchar(50) UNIQUE,
    `pay_start_time` datetime(6),
    `paid_time` datetime(6),
    `notify_data` longtext,
    `account_seller_id` varchar(100) NOT NULL,
    `create_at` datetime(6) NOT NULL
) default charset utf8
;
CREATE TABLE `pay_paymentorderitem` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `payment_order_id` integer NOT NULL,
    `order_id` varchar(12) NOT NULL
) default charset utf8
;
ALTER TABLE `pay_paymentorderitem` ADD CONSTRAINT `order_id_refs_id_77454739` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
ALTER TABLE `pay_paymentorderitem` ADD CONSTRAINT `payment_order_id_refs_id_27c5e655` FOREIGN KEY (`payment_order_id`) REFERENCES `pay_paymentorder` (`id`);
CREATE TABLE `pay_prepaytemp` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `settlement_id` varchar(12) NOT NULL,
    `through_cadus` bool NOT NULL
) default charset utf8
;
ALTER TABLE `pay_prepaytemp` ADD CONSTRAINT `settlement_id_refs_id_317b1fa0` FOREIGN KEY (`settlement_id`) REFERENCES `api_settlement` (`id`);

CREATE INDEX `pay_paymentorderitem_0ddf02f3` ON `pay_paymentorderitem` (`payment_order_id`);
CREATE INDEX `pay_prepaytemp_e8c21a4b` ON `pay_prepaytemp` (`settlement_id`);

COMMIT;
