BEGIN;

-- 增加一个字段
ALTER TABLE `pay_statement` add total_real_prepay double precision;

CREATE TABLE `pay_statementall` (
    `id` varchar(15) NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `status` integer NOT NULL,
    `settle_amount` double precision NOT NULL,
    `statement_date` integer NOT NULL,
    `merchant_confirm_time` datetime(6),
    `settle_time` datetime(6),
    `service_statement_id` varchar(15) NOT NULL UNIQUE,
    `maidan_statement_id` varchar(15) NOT NULL UNIQUE,
    `check_snapshot` longtext NOT NULL,
    `settle_snapshot` longtext NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `updated_at` datetime(6) NOT NULL,
    UNIQUE (`doctor_id`, `statement_date`)
)
;
ALTER TABLE `pay_statementall` ADD CONSTRAINT `service_statement_id_refs_id_66e56fa5` FOREIGN KEY (`service_statement_id`) REFERENCES `pay_statement` (`id`);
ALTER TABLE `pay_statementall` ADD CONSTRAINT `doctor_id_refs_id_a2d7e224` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `pay_statementall` ADD CONSTRAINT `maidan_statement_id_refs_id_e228f75d` FOREIGN KEY (`maidan_statement_id`) REFERENCES `maidan_statement` (`id`);
CREATE TABLE `pay_statementallaccount` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statementall_id` varchar(15) NOT NULL UNIQUE,
    `province_id` varchar(40),
    `city_id` varchar(40),
    `bank` varchar(30) NOT NULL,
    `subbranch` varchar(100)  NULL,
    `account_name` varchar(100) NOT NULL,
    `account_number` varchar(50) NOT NULL,
    `account_type` integer NOT NULL
)
;
ALTER TABLE `pay_statementallaccount` ADD CONSTRAINT `province_id_refs_id_1f709b29` FOREIGN KEY (`province_id`) REFERENCES `api_province` (`id`);
ALTER TABLE `pay_statementallaccount` ADD CONSTRAINT `statementall_id_refs_id_840fb340` FOREIGN KEY (`statementall_id`) REFERENCES `pay_statementall` (`id`);
ALTER TABLE `pay_statementallaccount` ADD CONSTRAINT `city_id_refs_id_7b4f3878` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `pay_statementalloperation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statementall_id` varchar(15) NOT NULL,
    `operator_id` char(32),
    `optype` integer NOT NULL,
    `role` integer NOT NULL,
    `operate_at` datetime(6),
    `content` varchar(300)
)
;
ALTER TABLE `pay_statementalloperation` ADD CONSTRAINT `operator_id_refs_id_1564af3d` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `pay_statementalloperation` ADD CONSTRAINT `statementall_id_refs_id_e11358e1` FOREIGN KEY (`statementall_id`) REFERENCES `pay_statementall` (`id`);
CREATE TABLE `pay_feedeductionall` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statementall_id` varchar(15) NOT NULL,
    `value` double precision NOT NULL,
    `comment` varchar(100) NOT NULL
)
;
ALTER TABLE `pay_feedeductionall` ADD CONSTRAINT `statementall_id_refs_id_8bc6967c` FOREIGN KEY (`statementall_id`) REFERENCES `pay_statementall` (`id`);

CREATE INDEX `pay_statementall_72821be1` ON `pay_statementall` (`doctor_id`);
CREATE INDEX `pay_statementallaccount_35b8c010` ON `pay_statementallaccount` (`province_id`);
CREATE INDEX `pay_statementallaccount_b376980e` ON `pay_statementallaccount` (`city_id`);
CREATE INDEX `pay_statementalloperation_454b9082` ON `pay_statementalloperation` (`statementall_id`);
CREATE INDEX `pay_statementalloperation_5e7ba3ec` ON `pay_statementalloperation` (`operator_id`);


CREATE INDEX `pay_feedeductionall_454b9082` ON `pay_feedeductionall` (`statementall_id`);

COMMIT;