-- Deploy gaia:20180327_create_service_home_tables to mysql

BEGIN;

CREATE TABLE `api_new_category_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `newcategory_id` integer NOT NULL,
    `tag_id` integer NOT NULL,
    UNIQUE (`newcategory_id`, `tag_id`)
)
;
ALTER TABLE `api_new_category_tags` ADD CONSTRAINT `tag_id_refs_id_c10aef3d` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `api_new_category_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `newcategory_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`newcategory_id`, `region_id`)
)
;
ALTER TABLE `api_new_category_regions` ADD CONSTRAINT `region_id_refs_id_2c790c53` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_new_category_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `newcategory_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`newcategory_id`, `city_id`)
)
;
ALTER TABLE `api_new_category_cities` ADD CONSTRAINT `city_id_refs_id_a252a3c4` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_new_category` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `icon` varchar(255) NOT NULL,
    `name` varchar(128) NOT NULL,
    `ordering` integer NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_new_category_tags` ADD CONSTRAINT `newcategory_id_refs_id_ef07d628` FOREIGN KEY (`newcategory_id`) REFERENCES `api_new_category` (`id`);
ALTER TABLE `api_new_category_regions` ADD CONSTRAINT `newcategory_id_refs_id_e014b200` FOREIGN KEY (`newcategory_id`) REFERENCES `api_new_category` (`id`);
ALTER TABLE `api_new_category_cities` ADD CONSTRAINT `newcategory_id_refs_id_8892af71` FOREIGN KEY (`newcategory_id`) REFERENCES `api_new_category` (`id`);
CREATE TABLE `api_service_home_background` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `background_img` varchar(255) NOT NULL,
    `font_color` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_service_home_operation_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `servicehomeoperation_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`servicehomeoperation_id`, `region_id`)
)
;
ALTER TABLE `api_service_home_operation_regions` ADD CONSTRAINT `region_id_refs_id_a6136911` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_service_home_operation_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `servicehomeoperation_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`servicehomeoperation_id`, `city_id`)
)
;
ALTER TABLE `api_service_home_operation_cities` ADD CONSTRAINT `city_id_refs_id_1a7c44cb` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_service_home_operation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `operation_type` varchar(2) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `display_port` integer NOT NULL,
    `details` longtext,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_service_home_operation_regions` ADD CONSTRAINT `servicehomeoperation_id_refs_id_4040c2d7` FOREIGN KEY (`servicehomeoperation_id`) REFERENCES `api_service_home_operation` (`id`);
ALTER TABLE `api_service_home_operation_cities` ADD CONSTRAINT `servicehomeoperation_id_refs_id_a85addd9` FOREIGN KEY (`servicehomeoperation_id`) REFERENCES `api_service_home_operation` (`id`);
ALTER TABLE `api_specialexterior` ADD COLUMN `new_image` varchar(255) NOT NULL;
ALTER TABLE `api_specialexterior` ADD COLUMN `new_big_image` varchar(255) NOT NULL;

COMMIT;
