-- Deploy gaia:2018_05_23_cashback to mysql

BEGIN;
CREATE TABLE `cashback_cashbackauditlog` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `status` varchar(2) NOT NULL, `time` datetime(6) NOT NULL, `reason` varchar(2) NULL);
CREATE TABLE `cashback_dialog` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `type` smallint NOT NULL UNIQUE, `packet_id` integer NOT NULL);
CREATE TABLE `cashback_dialogaction` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `action` smallint NOT NULL, `device_id` varchar(64) NOT NULL, `create_at` datetime(6) NOT NULL, `dialog_id` integer NOT NULL, `user_id` integer NULL);
CREATE TABLE `cashback_redpacket` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `packet_type` varchar(2) NOT NULL, `amount` double precision NOT NULL, `create_time` datetime(6) NOT NULL, `is_online` bool NOT NULL);
CREATE TABLE `cashback_registration` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `device_id` varchar(64) NULL, `device_type` varchar(32) NULL, `activated` bool NOT NULL, `register_time` datetime(6) NULL, `login_time` datetime(6) NULL, `invitee_id` integer NOT NULL, `inviter_id` integer NOT NULL);
CREATE TABLE `cashback_transactionlog` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `amount` double precision NOT NULL, `type` smallint NOT NULL, `state` smallint NOT NULL, `create_at` datetime(6) NOT NULL, `update_at` datetime(6) NOT NULL);
CREATE TABLE `cashback_transactionremark` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `event_type` smallint NOT NULL, `packet_id` integer NULL, `registration_id` integer NULL, `cdkey` varchar(32) NULL);
CREATE TABLE `cashback_userbalance` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `join_time` datetime(6) NOT NULL, `user_id` integer NOT NULL UNIQUE);
ALTER TABLE `cashback_transactionlog` ADD COLUMN `remark_id` integer NULL UNIQUE;
ALTER TABLE `cashback_transactionlog` ALTER COLUMN `remark_id` DROP DEFAULT;
ALTER TABLE `cashback_transactionlog` ADD COLUMN `user_id` integer NOT NULL;
ALTER TABLE `cashback_transactionlog` ALTER COLUMN `user_id` DROP DEFAULT;
ALTER TABLE `cashback_cashbackauditlog` ADD COLUMN `transactionlog_id` integer NOT NULL;
ALTER TABLE `cashback_cashbackauditlog` ALTER COLUMN `transactionlog_id` DROP DEFAULT;
ALTER TABLE `cashback_cashbackauditlog` ADD COLUMN `user_id` integer NOT NULL;
ALTER TABLE `cashback_cashbackauditlog` ALTER COLUMN `user_id` DROP DEFAULT;
ALTER TABLE `cashback_registration` ADD CONSTRAINT `cashback_registration_inviter_id_6ae39bf38c1b564_uniq` UNIQUE (`inviter_id`, `invitee_id`);
ALTER TABLE `cashback_dialogaction` ADD CONSTRAINT `cashback_dialoga_dialog_id_ae7e0f3ce933c40_fk_cashback_dialog_id` FOREIGN KEY (`dialog_id`) REFERENCES `cashback_dialog` (`id`);
ALTER TABLE `cashback_dialogaction` ADD CONSTRAINT `cashback_dialogaction_user_id_fd69a2523ad7957_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `cashback_registration` ADD CONSTRAINT `cashback_registratio_invitee_id_5948be275004494c_fk_auth_user_id` FOREIGN KEY (`invitee_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `cashback_registration` ADD CONSTRAINT `cashback_registratio_inviter_id_1167115956bde6ef_fk_auth_user_id` FOREIGN KEY (`inviter_id`) REFERENCES `auth_user` (`id`);
CREATE INDEX `cashback_transactionlog_599dcce2` ON `cashback_transactionlog` (`type`);
ALTER TABLE `cashback_userbalance` ADD CONSTRAINT `cashback_userbalance_user_id_3903dd937e41f9dd_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `cashback_transactionlog` ADD CONSTRAINT `cash_remark_id_770400ff774d8ee2_fk_cashback_transactionremark_id` FOREIGN KEY (`remark_id`) REFERENCES `cashback_transactionremark` (`id`);
CREATE INDEX `cashback_transactionlog_e8701ad4` ON `cashback_transactionlog` (`user_id`);
ALTER TABLE `cashback_transactionlog` ADD CONSTRAINT `cashback_transactionlog_user_id_1491fe6ea52da2dd_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE INDEX `cashback_cashbackauditlog_22c11a62` ON `cashback_cashbackauditlog` (`transactionlog_id`);
ALTER TABLE `cashback_cashbackauditlog` ADD CONSTRAINT `b4b5ef4e5853f9e198bf678ab1b7ae51` FOREIGN KEY (`transactionlog_id`) REFERENCES `cashback_transactionlog` (`id`);
CREATE INDEX `cashback_cashbackauditlog_e8701ad4` ON `cashback_cashbackauditlog` (`user_id`);
ALTER TABLE `cashback_cashbackauditlog` ADD CONSTRAINT `cashback_cashbackauditl_user_id_6fe3720e55930308_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

COMMIT;
