-- Deploy gaia:2019_08_29_add_market_table to mysql

BEGIN;

CREATE TABLE `api_market_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `reason` varchar(128) NOT NULL,
    `tag_name` varchar(128) NOT NULL,
    `description` varchar(128) NOT NULL,
    `tag_type` integer NOT NULL,
    `is_online` bool NOT NULL,
    `nums` integer NOT NULL,
    `operater` varchar(128) NOT NULL,
    `search_condition` longtext NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;

CREATE TABLE `api_market_personas` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer NOT NULL,
    `device_id` varchar(128) NOT NULL,
    `score` double precision NOT NULL,
    `weight` double precision NOT NULL,
    `pay_type` integer NOT NULL,
    UNIQUE (`device_id`, `tag_id`)
)
;

CREATE TABLE `api_market_activity_user_profile` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `age` integer NOT NULL,
    `city_id` varchar(128) NOT NULL,
    `device_id` varchar(128) NOT NULL,
    `active_time` varchar(32) NOT NULL,
    `register_time` varchar(32) NOT NULL,
    `sex` varchar(2) NOT NULL,
    `user_id` varchar(32) NOT NULL UNIQUE
)
;

alter table `api_pushcouponuser` add column `user_type` integer NOT NULL default 0;
alter table `api_pushcoupon` add column `market_id` text;
alter table `api_pushtask2` add column `market_id` text;

COMMIT;
