-- Deploy gaia:api_2016_03_09_create_table_campaign_coupon_and_share to mysql

BEGIN;

CREATE TABLE `api_share` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(100) NOT NULL,
    `content` varchar(300) NOT NULL,
    `moments` varchar(300) NOT NULL,
    `weibo` varchar(300) NOT NULL,
    `image` varchar(300) NOT NULL
)
;

CREATE TABLE `api_campaigncouponpage` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `campaign_id` integer NOT NULL UNIQUE,
    `banner` varchar(1024) NOT NULL,
    `rule` longtext NOT NULL,
    `share_id` integer NOT NULL
)
;
ALTER TABLE `api_campaigncouponpage` ADD CONSTRAINT `share_id_refs_id_88b526f4` FOREIGN KEY (`share_id`) REFERENCES `api_share` (`id`);
ALTER TABLE `api_campaigncouponpage` ADD CONSTRAINT `campaign_id_refs_id_700eb334` FOREIGN KEY (`campaign_id`) REFERENCES `api_campaign` (`id`);

ALTER TABLE `api_campaign` ADD COLUMN `share_id` integer DEFAULT NULL;
ALTER TABLE `api_campaign` ADD CONSTRAINT `compaign_share_id_refs_id_2jnak190` FOREIGN KEY (`share_id`) REFERENCES `api_share` (`id`);

CREATE TABLE `api_campaigncoupon` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `campaigncouponpage_id` integer NOT NULL,
    `coupon_id` integer NOT NULL,
    `ordering` integer NOT NULL
)
;
ALTER TABLE `api_campaigncoupon` ADD CONSTRAINT `campaigncouponpage_id_refs_id_a9b7bd43` FOREIGN KEY (`campaigncouponpage_id`) REFERENCES `api_campaigncouponpage` (`id`);
ALTER TABLE `api_campaigncoupon` ADD CONSTRAINT `coupon_id_refs_id_dbb44f14` FOREIGN KEY (`coupon_id`) REFERENCES `api_coupon` (`id`);

COMMIT;
