-- Deploy gaia:api_2018_05_15_create_table_college to mysql

BEGIN;

CREATE TABLE `api_college` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(64) NOT NULL UNIQUE,
    `level` smallint NOT NULL,
    `city_id` varchar(40) NOT NULL,
    `is_online` bool NOT NULL,
    `is_recommend` bool NOT NULL
)
;
ALTER TABLE `api_college` ADD CONSTRAINT `city_id_refs_id_6d231a47` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);

CREATE TABLE `api_userextratocollege` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `college_id` integer,
    `userextra_id` integer,
    UNIQUE (`college_id`, `userextra_id`)
)
;
ALTER TABLE `api_userextratocollege` ADD CONSTRAINT `userextra_id_refs_id_6587e374` FOREIGN KEY (`userextra_id`) REFERENCES `api_userextra` (`id`);
ALTER TABLE `api_userextratocollege` ADD CONSTRAINT `college_id_refs_id_69ff0426` FOREIGN KEY (`college_id`) REFERENCES `api_college` (`id`);
CREATE INDEX `api_userextratocollege_ac3b121a` ON `api_userextratocollege` (`college_id`);
CREATE INDEX `api_userextratocollege_645dc4c9` ON `api_userextratocollege` (`userextra_id`);
COMMIT;

